﻿var openEndAnalysis = {
    context: $(".v-openEndAnalysis"),
    tabs: null,
    listView: null,
    resultsDataTable: {
        datatable: null,
        filter: function (topics) {
            if (this.datatable) {
                this.datatable.a4datatable("option", "ajaxParams", { "topics": topics });
                this.datatable.a4datatable("refresh", true);
            }
        },
        refresh: function (variableName) {
            if (this.datatable) {
                this.datatable.a4datatable("option", "ajaxParams", { "variable": variableName });
                this.datatable.a4datatable("refresh", true);
            }
            else {
                var datatable = $(".open-end-table", openEndAnalysis.context).a4datatable({
                    height: "full",
                    ajaxAction: a4.getSurveyAction("GetOpenEndAnalysisDocuments", "Analyze"),
                    ajaxParams: { "variable": variableName },
                    columns: [
                        { "Name": "Id", "Title": resources.Id, "Visible": false, "Key": true },
                        { "Name": "RespondentId", "Title": resources.Respondent, "Width": "80px" },
                        { "Name": "Matrix", "Title": resources.Matrix, "Width": "80px" },
                        { "Name": "Mention", "Title": resources.Mention, "Width": "80px" },
                        { "Name": "Text", "Title": resources.OpenEnd, "HideInSelector": true, "Class": "text-column", "Data": openEndAnalysis.renderTextWithTopics },
                        { "Name": "Score", "Title": resources.Score, "Width": "80px", "Type": "Number" },
                        { "Name": "Sentiment", "Title": resources.Sentiment, "Width": "150px", "Class": "sentiment-column", "Data": openEndAnalysis.renderSentimentChart }
                    ],
                    contextMenuItems: [{ "Action": "sentences", "Label": resources.Sentences }],
                    contextMenuClick: function (event, data) {
                        var row = data.row;
                        var action = data.action;

                        switch (action) {
                            case "sentences":
                                modalDialog.showWindow(a4.getSurveyAction("OpenEndAnalysisSentences", "Analyze", { documentId: row.Id }), 700);
                                break;
                        };
                    },
                    stateKey: "OpenEndAnalysisResults",
                    ready: function () {
                        $(".top", datatable).append($(".topics-filter", openEndAnalysis.context));
                    }
                });

                this.datatable = datatable;
            }
        }
    },
    topicsDataTable: {
        datatable: null,
        refresh: function (variableName) {
            if (this.datatable) {
                this.datatable.a4datatable("option", "ajaxParams", { "variable": variableName });
                this.datatable.a4datatable("refresh", true);
            }
            else {
                this.datatable = $(".topics-table", openEndAnalysis.context).a4datatable({
                    height: "full",
                    ajaxAction: a4.getSurveyAction("GetOpenEndAnalysisTopics", "Analyze"),
                    ajaxParams: { "variable": variableName },
                    columns: [
                        { "Name": "Text", "Title": "Topic", "HideInSelector": true },
                        { "Name": "Frequency", "Title": resources.Frequency },
                        { "Name": "Score", "Title": resources.Score, "Width": "80px", "Type": "Number" },
                        { "Name": "Sentiment", "Title": resources.Sentiment, "Width": "150px", "Class": "sentiment-column", "Data": openEndAnalysis.renderSentimentChart }
                    ],
                    contextMenuItems: [{ "Action": "answers", "Label": resources.Answers }],
                    contextMenuClick: function (event, data) {
                        var row = data.row;
                        var action = data.action;

                        switch (action) {
                            case "answers":
                                modalDialog.showWindow(a4.getSurveyAction("OpenEndAnalysisTopicDocuments", "Analyze", { variable: variableName, topic: row.Text }), 700);
                                break;
                        };
                    },
                    stateKey: "OpenEndAnalysisTopics",
                });
            }
        }
    },
    activeDataTable: null,
    initialize: function () {
        this.bindEvents();
        this.initializeTabs();
        this.initializeListView();
    },
    bindEvents: function () {
        openEndAnalysis.context.on("click", ".enable-variable", function () {
            var selectedNode = openEndAnalysis.listView.a4listview("getHighlightedNode");

            if (selectedNode) {
                a4.callServerMethod(a4.getSurveyAction("EnableOpenEndAnalysisVariable", "Analyze"), { variable: selectedNode.Name }, function (result) {
                    openEndAnalysis.toggleVariableContainers(true);
                    openEndAnalysis.listView.a4listview("refresh");
                });
            }
        });
    },
    initializeTabs: function () {
        openEndAnalysis.tabs = $(".v-openEndAnalysisTabs", this.context).a4tabs({
            defaultTab: "openEndAnswers",
            load: function (e, d) {
                openEndAnalysis.setActiveDataTable(d.id);
            },
            change: function (e, d) {
                openEndAnalysis.setActiveDataTable(d.id);

                if (!openEndAnalysis.listView)
                    return;

                var selectedNode = openEndAnalysis.listView.a4listview("getHighlightedNode");
                if (!selectedNode)
                    return;

                openEndAnalysis.activeDataTable.refresh(selectedNode.Name);

                $(window).resize();
            }
        });
    },
    refreshTopicsAutocomplete: function (variableName) {
        var topicsAutocomplete = $("#TopicsAutocomplete", openEndAnalysis.context);
        if (topicsAutocomplete.hasClass("autocomplete"))
            topicsAutocomplete.a4autocomplete("destroy");

        var autocomplete = topicsAutocomplete.a4autocomplete({
            ajaxAction: a4.getSurveyAction("GetOpenEndAnalysisTopicsForFilter", "Analyze"),
            ajaxParams: { variable: variableName },
            resources: { "PlaceHolder": "Filter Topics" },
            multipleSelection: true,
            valueProperty: "Text",
            labelProperty: "Text",
            hideSelectedItems: true,
            change: function () {
                var value = autocomplete.a4autocomplete("getValue");
                openEndAnalysis.resultsDataTable.filter(_.pluck(value, "Text"));
            },
            render: {
                item: function (item) {
                    return item.Text + ' (' + item.Frequency + ')';
                }
            }
        });
    },
    setActiveDataTable: function (tabName) {
        switch (tabName) {
            case "openEndAnswers":
                openEndAnalysis.activeDataTable = openEndAnalysis.resultsDataTable;
                break;
            case "topics":
                openEndAnalysis.activeDataTable = openEndAnalysis.topicsDataTable;
                break;
        }
    },
    initializeListView: function () {
        openEndAnalysis.listView = $(".variables-list", this.context).a4listview({
            ajaxAction: a4.getSurveyAction("GetOpenEndedVariables", "Analyze"),
            properties: { Key: "Name" },
            actionButtons: [
                { Action: "unlock", Icon: "lock", DisplayCondition: function (item) { return !item.Enabled; } },
                { Action: "lock", Icon: "unlock", DisplayCondition: function (item) { return item.Enabled; } }
            ],
            saveState: true,
            highlightFirstNode: true,
            stateKey: "OpenEndAnalysisVariables",
            draw: function (event, data) {
                if (data.selectedNode)
                    openEndAnalysis.selectVariable(data.selectedNode.Name, data.selectedNode.Enabled);
            },
            selectNode: function (event, data) {
                if (data.selected)
                    openEndAnalysis.selectVariable(data.node.Name, data.node.Enabled);
            },
            icons: null,
            displayActionButtonsOnHover: false
        });
    },
    selectVariable: function (variableName, enabled) {
        var selectedVariable = $(".selected-variable", openEndAnalysis.context);
        $(".selected-variable__name", selectedVariable).html(variableName);

        openEndAnalysis.toggleVariableContainers(enabled);

        if (enabled) {
            if (openEndAnalysis.activeDataTable) {
                openEndAnalysis.activeDataTable.refresh(variableName);
            }
            var data = {
                variable: variableName
            };
            a4.callServerMethod(a4.getSurveyAction("GetVariableTotalScore", "Analyze"), data, function (result) {
                if (result) {
                    $(".selected-variable__score", selectedVariable).html(result.Score);
                    $(".selected-variable__sentiment", selectedVariable).html(result.SentimentLabel);
                    $(".selected-variable__score, .selected-variable__sentiment", selectedVariable).addClass("sentiment__type" + result.Sentiment);
                }
            });

            openEndAnalysis.refreshTopicsAutocomplete(variableName);
        } else {
            $(".selected-variable__score", selectedVariable).html("Locked");
            $(".selected-variable__sentiment", selectedVariable).empty();
        }
    },
    toggleVariableContainers: function (enabled) {
        $(".disabled-variable-message").toggle(!enabled);
        $(".v-openEndAnalysisTabs").toggle(enabled);
    },
    renderSentimentChart: function (row) {
        var container = $("<div />", { "class": "sentiment-container" });

        var chart = $("<div />", { "class": "sentiment-chart" });
        var positive = $("<div />", { "class": "sentiment-chart__positive-bar", "css": { "width": (row.PositiveScore * 100) + "%" } });
        var neutral = $("<div />", { "class": "sentiment-chart__neutral-bar", "css": { "width": (row.NeutralScore * 100) + "%" } });
        var negative = $("<div />", { "class": "sentiment-chart__negative-bar", "css": { "width": (row.NegativeScore * 100) + "%" } });
        chart.append(positive);
        chart.append(neutral);
        chart.append(negative);
        container.append(chart);

        var label = $("<div />", { "class": "sentiment-label" });
        label.append(row.Sentiment);
        container.append(label);

        return container.get(0).outerHTML;
    },
    renderTextWithTopics: function (row) {
        if (!row.Topics || row.Topics.length === 0) {
            return row.Text;
        }

        var sortedTopics = _.sortBy(row.Topics, function (topic) {
            return topic.Offset
        });

        var formattedText = row.Text;
        for (var i = sortedTopics.length - 1; i >= 0; i--) {
            var topic = sortedTopics[i];
            var topicValue = row.Text.substr(topic.Offset, topic.Length);
            formattedText = "<span class=\"highlighted-text\">" + topicValue + "</span>" + formattedText.substr(topic.Offset + topic.Length);
        }
        return row.Text.substr(0, sortedTopics[0].Offset) + formattedText;
    }
};

$(document).ready(function () {
    if (openEndAnalysis.context.length > 0) {
        openEndAnalysis.initialize();
    }
});